/*
 * MyString.cpp
 *
 * Implementation of the MyString class
 * Version 0.1
 *   -- Initial version
 */

#include <iostream>
#include <string>
using namespace std;

#include "MyString.h"

// Standard constructor, makes our string a null-terminated,
// 0 length string
MyString::MyString()
{
  storagePtr = &initialStorage[0];
  allocatedSpace = 20;
  stringLength = 0;
  initialStorage[0] = '\0';
}

// MakeString returns a C++ style string constructed from
// our internal "C" style string
string MyString::MakeString()
{
  string returnVal = storagePtr;
  return returnVal;
}

// MakeInt utilized the C Standard library function "atoi" 
// to convert our string to an integer 
int MyString::MakeInt()
{
  return( atoi(storagePtr) );
}

// readString tells cin to read in a new line of text
// into our string
int MyString::readString()
{
  return readString(allocatedSpace-1);
}

int MyString::readString(int maxSize)
{
  // Make sure we have enough storage 
  if (!growStorage(maxSize))
    return 0;
    
  cin.getline(storagePtr,maxSize);
  stringLength = strlen(storagePtr);
  return stringLength;
}

// setValue would provide a way to assign an existing 
// value to our string (that is, without reading in from
// standard console)
bool MyString::setValue(string cppString)
{
  int spaceNeeded = cppString.length();
   
  // make sure we have enough space to hold the new string
  if (spaceNeeded > allocatedSpace)
  {
     if (!growStorage(spaceNeeded+1))
        return false;
  }
  
  strcpy(storagePtr,cppString.c_str());
  return true;
}

// growStorage is a private member function which is used
// to grow the buffer used to store our string when needed.
// We grow the buffer in blocks of 32 bytes to minimize the 
// amount of memory allocations we need to do.
bool MyString::growStorage(int spaceNeeded)
{
  // Make sure it really needs to grow
  if (spaceNeeded < allocatedSpace)
    return true;
    
  // grow in chunks of 32 bytes
  int padding = spaceNeeded % 32;
  spaceNeeded += (32 - padding);
  
  // allocate new storage
  char *newStoragePtr = new char[spaceNeeded];
  
  // fail if new storage allocation fails without
  // touching the existing contents of our string
  if (!newStoragePtr)
    return false;
    
  // copy the contents of the old string into the new
  strcpy(newStoragePtr,storagePtr);
  
  // delete the old string only if it's pointing at 
  // dynamically allocated memory.
  if (allocatedSpace != 20)
    delete [] storagePtr;
  
  // Take note of the new size of our allocated space
  allocatedSpace = spaceNeeded;
  
  // store the pointer to the new storage in our class
  storagePtr = newStoragePtr;
  
  return true;
}

